#pragma once

#include "SkinManager.h"
#include "../GifImage.h"

enum DRAW_MODE	// ͼģʽ
{
	DRAW_MODE_STRETCH,	// 
	DRAW_MODE_CENTER	// 
};

class CSkinPictureBox : public CWindowImpl<CSkinPictureBox, CStatic>
{
public:
	CSkinPictureBox(void);
	~CSkinPictureBox(void);

	BEGIN_MSG_MAP_EX(CSkinPictureBox)
		MSG_WM_ERASEBKGND(OnEraseBkgnd)
		MSG_WM_PAINT(OnPaint)
		MSG_WM_LBUTTONDOWN(OnLButtonDown)
		MSG_WM_LBUTTONUP(OnLButtonUp)
		MSG_WM_MOUSEMOVE(OnMouseMove)
		MSG_WM_MOUSELEAVE(OnMouseLeave)
		MSG_WM_SETFOCUS(OnSetFocus)
		MSG_WM_KILLFOCUS(OnKillFocus)
		MSG_WM_SETCURSOR(OnSetCursor)
		MSG_WM_TIMER(OnTimer)
		MESSAGE_RANGE_HANDLER_EX(WM_MOUSEFIRST, WM_MOUSELAST, OnMouseMessage)
		MSG_WM_DESTROY(OnDestroy)
	END_MSG_MAP()

public:
	BOOL SetBgPic(LPCTSTR lpNormal, LPCTSTR lpHighlight, LPCTSTR lpDown);
	BOOL SetBitmap(LPCTSTR lpszFileName, BOOL bIsGif = FALSE);	// GifҪ·
	BOOL SetBitmap(const BYTE* lpData, DWORD dwSize);
	void SetToolTipText(LPCTSTR lpszText);
	void SetDrawMode(DRAW_MODE nMode = DRAW_MODE_CENTER);
	void SetTransparent(BOOL bTransparent, HDC hBgDC);
	void SetShowCursor(BOOL bShow);

	BOOL SubclassWindow(HWND hWnd);

private:
	BOOL OnEraseBkgnd(CDCHandle dc);
	void OnPaint(CDCHandle dc);
	void OnLButtonDown(UINT nFlags, CPoint point);
	void OnLButtonUp(UINT nFlags, CPoint point);
	void OnMouseMove(UINT nFlags, CPoint point);
	void OnMouseLeave();
	void OnSetFocus(CWindow wndOld);
	void OnKillFocus(CWindow wndFocus);
	BOOL OnSetCursor(CWindow wnd, UINT nHitTest, UINT message);
	void OnTimer(UINT_PTR nIDEvent);
	LRESULT OnMouseMessage(UINT uMsg, WPARAM wParam, LPARAM lParam);
	void OnDestroy();

	BOOL StartTrackMouseLeave();
	void DrawParentWndBg(HDC hDC);
	void CalcCenterRect(CRect& rcDest, int cx, int cy, CRect& rcCenter);

private:
	CImageEx * m_lpBgImgN, * m_lpBgImgH, * m_lpBgImgD;
	CImageEx * m_lpImage;
	CGifImage * m_lpGifImage;

	CToolTipCtrl m_ToolTipCtrl;

	HCURSOR m_hCursor;

	BOOL m_bFocus, m_bPress, m_bHover, m_bMouseTracking;

	DRAW_MODE m_nDrawMode;
	DWORD m_dwTimerId;
	BOOL m_bTransparent;
	HDC m_hBgDC;
};
